# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .vertex_embedding_mode import VertexEmbeddingMode

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class VertexTextEmbedding(pydantic.BaseModel):
    model_name: typing.Optional[str] = pydantic.Field(description="The modelId of the VertexAI model to use.")
    embed_batch_size: typing.Optional[int] = pydantic.Field(description="The batch size for embedding calls.")
    num_workers: typing.Optional[int]
    location: str = pydantic.Field(description="The default location to use when making API calls.")
    project: str = pydantic.Field(description="The default GCP project to use when making Vertex API calls.")
    embed_mode: typing.Optional[VertexEmbeddingMode] = pydantic.Field(description="The embedding mode to use.")
    additional_kwargs: typing.Optional[typing.Dict[str, typing.Any]] = pydantic.Field(
        description="Additional kwargs for the Vertex."
    )
    client_email: typing.Optional[str]
    token_uri: typing.Optional[str]
    private_key_id: typing.Optional[str]
    private_key: typing.Optional[str]
    class_name: typing.Optional[str]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
