# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .data_sink_create import DataSinkCreate
from .eval_execution_params import EvalExecutionParams
from .llama_parse_parameters import LlamaParseParameters
from .pipeline_create_embedding_config import PipelineCreateEmbeddingConfig
from .pipeline_create_transform_config import PipelineCreateTransformConfig
from .pipeline_metadata_config import PipelineMetadataConfig
from .pipeline_type import PipelineType
from .preset_retrieval_params import PresetRetrievalParams

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class PipelineCreate(pydantic.BaseModel):
    """
    Schema for creating a pipeline.
    """

    embedding_config: typing.Optional[PipelineCreateEmbeddingConfig]
    transform_config: typing.Optional[PipelineCreateTransformConfig] = pydantic.Field(
        description="Configuration for the transformation."
    )
    data_sink_id: typing.Optional[str]
    embedding_model_config_id: typing.Optional[str]
    data_sink: typing.Optional[DataSinkCreate]
    preset_retrieval_parameters: typing.Optional[PresetRetrievalParams] = pydantic.Field(
        description="Preset retrieval parameters for the pipeline."
    )
    eval_parameters: typing.Optional[EvalExecutionParams] = pydantic.Field(
        description="Eval parameters for the pipeline."
    )
    llama_parse_parameters: typing.Optional[LlamaParseParameters]
    status: typing.Optional[str]
    metadata_config: typing.Optional[PipelineMetadataConfig]
    name: str
    pipeline_type: typing.Optional[PipelineType] = pydantic.Field(
        description="Type of pipeline. Either PLAYGROUND or MANAGED."
    )
    managed_pipeline_id: typing.Optional[str]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
