# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class FileCountByStatusResponse(pydantic.BaseModel):
    counts: typing.Dict[str, int] = pydantic.Field(description="The counts of files by status")
    total_count: int = pydantic.Field(description="The total number of files")
    pipeline_id: typing.Optional[str]
    data_source_id: typing.Optional[str]
    only_manually_uploaded: typing.Optional[bool] = pydantic.Field(
        description="Whether to only count manually uploaded files"
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
