# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .file_permission_info_value import FilePermissionInfoValue
from .file_resource_info_value import FileResourceInfoValue

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class File(pydantic.BaseModel):
    """
    Schema for a file.
    """

    id: str = pydantic.Field(description="Unique identifier")
    created_at: typing.Optional[dt.datetime]
    updated_at: typing.Optional[dt.datetime]
    name: str
    external_file_id: str = pydantic.Field(description="The ID of the file in the external system")
    file_size: typing.Optional[int]
    file_type: typing.Optional[str]
    project_id: str = pydantic.Field(description="The ID of the project that the file belongs to")
    last_modified_at: typing.Optional[dt.datetime]
    resource_info: typing.Optional[typing.Dict[str, typing.Optional[FileResourceInfoValue]]]
    permission_info: typing.Optional[typing.Dict[str, typing.Optional[FilePermissionInfoValue]]]
    data_source_id: typing.Optional[str]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
