# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .extract_resultset_data import ExtractResultsetData
from .extract_resultset_extraction_metadata_value import ExtractResultsetExtractionMetadataValue

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ExtractResultset(pydantic.BaseModel):
    """
    Schema for an extraction resultset.
    """

    run_id: str = pydantic.Field(description="The id of the extraction run")
    extraction_agent_id: str = pydantic.Field(description="The id of the extraction agent")
    data: typing.Optional[ExtractResultsetData] = pydantic.Field(description="The data extracted from the file")
    extraction_metadata: typing.Dict[str, typing.Optional[ExtractResultsetExtractionMetadataValue]] = pydantic.Field(
        description="The metadata extracted from the file"
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
