# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .extract_config import ExtractConfig
from .extract_job_create_data_schema_override import ExtractJobCreateDataSchemaOverride
from .webhook_configuration import WebhookConfiguration

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ExtractJobCreate(pydantic.BaseModel):
    """
    Schema for creating an extraction job.
    """

    webhook_configurations: typing.Optional[typing.List[WebhookConfiguration]]
    extraction_agent_id: str = pydantic.Field(description="The id of the extraction agent")
    file_id: str = pydantic.Field(description="The id of the file")
    data_schema_override: typing.Optional[ExtractJobCreateDataSchemaOverride] = pydantic.Field(
        description="The data schema to override the extraction agent's data schema with"
    )
    config_override: typing.Optional[ExtractConfig]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
