# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class CompositeRetrievedTextNode(pydantic.BaseModel):
    id: str = pydantic.Field(description="The ID of the retrieved node.")
    retriever_id: str = pydantic.Field(description="The ID of the retriever this node was retrieved from.")
    retriever_pipeline_name: str = pydantic.Field(
        description="The name of the retrieval pipeline this node was retrieved from."
    )
    pipeline_id: str = pydantic.Field(description="The ID of the pipeline this node was retrieved from.")
    metadata: typing.Optional[typing.Dict[str, typing.Any]] = pydantic.Field(
        description="Metadata associated with the retrieved node."
    )
    text: str = pydantic.Field(description="The text of the retrieved node.")
    start_char_idx: typing.Optional[int]
    end_char_idx: typing.Optional[int]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
