# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .composite_retrieved_text_node_with_score import CompositeRetrievedTextNodeWithScore
from .page_figure_node_with_score import PageFigureNodeWithScore
from .page_screenshot_node_with_score import PageScreenshotNodeWithScore

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class CompositeRetrievalResult(pydantic.BaseModel):
    nodes: typing.Optional[typing.List[CompositeRetrievedTextNodeWithScore]] = pydantic.Field(
        description="The retrieved nodes from the composite retrieval."
    )
    image_nodes: typing.Optional[typing.List[PageScreenshotNodeWithScore]] = pydantic.Field(
        description="The image nodes retrieved by the pipeline for the given query. Deprecated - will soon be replaced with 'page_screenshot_nodes'."
    )
    page_figure_nodes: typing.Optional[typing.List[PageFigureNodeWithScore]] = pydantic.Field(
        description="The page figure nodes retrieved by the pipeline for the given query."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
