# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class CloudS3DataSource(pydantic.BaseModel):
    supports_access_control: typing.Optional[bool]
    bucket: str = pydantic.Field(description="The name of the S3 bucket to read from.")
    prefix: typing.Optional[str]
    regex_pattern: typing.Optional[str]
    aws_access_id: typing.Optional[str]
    aws_access_secret: typing.Optional[str]
    s_3_endpoint_url: typing.Optional[str] = pydantic.Field(alias="s3_endpoint_url")
    class_name: typing.Optional[str]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
