# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class CloudOneDriveDataSource(pydantic.BaseModel):
    supports_access_control: typing.Optional[bool]
    user_principal_name: str = pydantic.Field(description="The user principal name to use for authentication.")
    folder_path: typing.Optional[str]
    folder_id: typing.Optional[str]
    client_id: str = pydantic.Field(description="The client ID to use for authentication.")
    client_secret: str = pydantic.Field(description="The client secret to use for authentication.")
    tenant_id: str = pydantic.Field(description="The tenant ID to use for authentication.")
    required_exts: typing.Optional[typing.List[str]]
    class_name: typing.Optional[str]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
