# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class CloudConfluenceDataSource(pydantic.BaseModel):
    supports_access_control: typing.Optional[bool]
    server_url: str = pydantic.Field(description="The server URL of the Confluence instance.")
    authentication_mechanism: str = pydantic.Field(
        description="Type of Authentication for connecting to Confluence APIs."
    )
    user_name: typing.Optional[str]
    api_token: typing.Optional[str]
    space_key: typing.Optional[str]
    page_ids: typing.Optional[str]
    cql: typing.Optional[str]
    label: typing.Optional[str]
    index_restricted_pages: typing.Optional[bool] = pydantic.Field(description="Whether to index restricted pages.")
    keep_markdown_format: typing.Optional[bool] = pydantic.Field(description="Whether to keep the markdown format.")
    class_name: typing.Optional[str]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
