# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .classification_result import ClassificationResult

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ClassifyResponse(pydantic.BaseModel):
    """
    Response model for the classify endpoint following AIP-132 pagination standard.

    Contains classification results with pagination support and summary statistics.
    """

    items: typing.List[ClassificationResult] = pydantic.Field(description="The list of items.")
    next_page_token: typing.Optional[str]
    total_size: typing.Optional[int]
    unknown_count: int = pydantic.Field(description="Number of files that couldn't be classified")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
